package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementAutopilotEvent;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementAutopilotPolicyStatusDetailCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementAutopilotEventRequest extends EntityRequest<DeviceManagementAutopilotEvent> {

    public DeviceManagementAutopilotEventRequest(ContextPath contextPath) {
        super(DeviceManagementAutopilotEvent.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementAutopilotPolicyStatusDetailCollectionRequest policyStatusDetails() {
        return new DeviceManagementAutopilotPolicyStatusDetailCollectionRequest(
                        contextPath.addSegment("policyStatusDetails"));
    }

    public DeviceManagementAutopilotPolicyStatusDetailRequest policyStatusDetails(String id) {
        return new DeviceManagementAutopilotPolicyStatusDetailRequest(contextPath.addSegment("policyStatusDetails").addKeys(new NameValue(id.toString())));
    }

}
