package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementAbstractComplexSettingInstance;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementAbstractComplexSettingInstanceRequest extends EntityRequest<DeviceManagementAbstractComplexSettingInstance> {

    public DeviceManagementAbstractComplexSettingInstanceRequest(ContextPath contextPath) {
        super(DeviceManagementAbstractComplexSettingInstance.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementSettingInstanceCollectionRequest value() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("value"));
    }

    public DeviceManagementSettingInstanceRequest value(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("value").addKeys(new NameValue(id.toString())));
    }

}
