package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.DeviceLogCollectionResponse;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceLogCollectionResponseRequest extends EntityRequest<DeviceLogCollectionResponse> {

    public DeviceLogCollectionResponseRequest(ContextPath contextPath) {
        super(DeviceLogCollectionResponse.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "createDownloadUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> createDownloadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDownloadUrl"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
