package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.DeviceHealthScriptRemediationHistory;
import odata.msgraph.client.beta.entity.DeviceHealthScript;
import odata.msgraph.client.beta.entity.DeviceHealthScriptAssignment;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceHealthScriptRequest extends EntityRequest<DeviceHealthScript> {

    public DeviceHealthScriptRequest(ContextPath contextPath) {
        super(DeviceHealthScript.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceHealthScriptAssignmentCollectionRequest assignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public DeviceHealthScriptAssignmentRequest assignments(String id) {
        return new DeviceHealthScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceHealthScriptRunSummaryRequest runSummary() {
        return new DeviceHealthScriptRunSummaryRequest(contextPath.addSegment("runSummary"));
    }

    public DeviceHealthScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceHealthScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"));
    }

    public DeviceHealthScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceHealthScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceHealthScriptAssignment> deviceHealthScriptAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceHealthScriptAssignments", "Collection(microsoft.graph.deviceHealthScriptAssignment)", deviceHealthScriptAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "updateGlobalScript")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> updateGlobalScript(String version) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateGlobalScript"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getGlobalScriptHighestAvailableVersion")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getGlobalScriptHighestAvailableVersion() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getGlobalScriptHighestAvailableVersion"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getRemediationHistory")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceHealthScriptRemediationHistory> getRemediationHistory() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceHealthScriptRemediationHistory>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRemediationHistory"), DeviceHealthScriptRemediationHistory.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
