package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.DeviceConfiguration;
import odata.msgraph.client.beta.entity.DeviceConfigurationAssignment;
import odata.msgraph.client.beta.entity.DeviceConfigurationGroupAssignment;
import odata.msgraph.client.beta.entity.WindowsAssignedAccessProfile;
import odata.msgraph.client.beta.entity.WindowsPrivacyDataAccessControlItem;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SettingStateDeviceSummaryCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceConfigurationRequest extends EntityRequest<DeviceConfiguration> {

    public DeviceConfigurationRequest(ContextPath contextPath) {
        super(DeviceConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceConfigurationGroupAssignmentCollectionRequest groupAssignments() {
        return new DeviceConfigurationGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"));
    }

    public DeviceConfigurationGroupAssignmentRequest groupAssignments(String id) {
        return new DeviceConfigurationGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationAssignmentCollectionRequest assignments() {
        return new DeviceConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public DeviceConfigurationAssignmentRequest assignments(String id) {
        return new DeviceConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new DeviceConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    public DeviceConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new DeviceConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationUserStatusCollectionRequest userStatuses() {
        return new DeviceConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"));
    }

    public DeviceConfigurationUserStatusRequest userStatuses(String id) {
        return new DeviceConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationDeviceOverviewRequest deviceStatusOverview() {
        return new DeviceConfigurationDeviceOverviewRequest(contextPath.addSegment("deviceStatusOverview"));
    }

    public DeviceConfigurationUserOverviewRequest userStatusOverview() {
        return new DeviceConfigurationUserOverviewRequest(contextPath.addSegment("userStatusOverview"));
    }

    public SettingStateDeviceSummaryCollectionRequest deviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"));
    }

    public SettingStateDeviceSummaryRequest deviceSettingStateSummaries(String id) {
        return new SettingStateDeviceSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceConfigurationAssignment> assign(List<DeviceConfigurationGroupAssignment> deviceConfigurationGroupAssignments, List<DeviceConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceConfigurationGroupAssignments", "Collection(microsoft.graph.deviceConfigurationGroupAssignment)", deviceConfigurationGroupAssignments)
            .put("assignments", "Collection(microsoft.graph.deviceConfigurationAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceConfigurationAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "windowsPrivacyAccessControls")
    @JsonIgnore
    public ActionRequestNoReturn windowsPrivacyAccessControls(List<WindowsPrivacyDataAccessControlItem> windowsPrivacyAccessControls) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("windowsPrivacyAccessControls", "Collection(microsoft.graph.windowsPrivacyDataAccessControlItem)", windowsPrivacyAccessControls)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsPrivacyAccessControls"), _parameters);
    }

    @Action(name = "assignedAccessMultiModeProfiles")
    @JsonIgnore
    public ActionRequestNoReturn assignedAccessMultiModeProfiles(List<WindowsAssignedAccessProfile> assignedAccessMultiModeProfiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignedAccessMultiModeProfiles", "Collection(microsoft.graph.windowsAssignedAccessProfile)", assignedAccessMultiModeProfiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignedAccessMultiModeProfiles"), _parameters);
    }

}
