package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.DeviceComplianceScript;
import odata.msgraph.client.beta.entity.DeviceHealthScriptAssignment;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceComplianceScriptRequest extends EntityRequest<DeviceComplianceScript> {

    public DeviceComplianceScriptRequest(ContextPath contextPath) {
        super(DeviceComplianceScript.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceHealthScriptAssignmentCollectionRequest assignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public DeviceHealthScriptAssignmentRequest assignments(String id) {
        return new DeviceHealthScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceComplianceScriptRunSummaryRequest runSummary() {
        return new DeviceComplianceScriptRunSummaryRequest(contextPath.addSegment("runSummary"));
    }

    public DeviceComplianceScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceComplianceScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"));
    }

    public DeviceComplianceScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceComplianceScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceHealthScriptAssignment> deviceHealthScriptAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceHealthScriptAssignments", "Collection(microsoft.graph.deviceHealthScriptAssignment)", deviceHealthScriptAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
