package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceCompliancePolicySettingStateSummary;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceSettingStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceCompliancePolicySettingStateSummaryRequest extends EntityRequest<DeviceCompliancePolicySettingStateSummary> {

    public DeviceCompliancePolicySettingStateSummaryRequest(ContextPath contextPath) {
        super(DeviceCompliancePolicySettingStateSummary.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceComplianceSettingStateCollectionRequest deviceComplianceSettingStates() {
        return new DeviceComplianceSettingStateCollectionRequest(
                        contextPath.addSegment("deviceComplianceSettingStates"));
    }

    public DeviceComplianceSettingStateRequest deviceComplianceSettingStates(String id) {
        return new DeviceComplianceSettingStateRequest(contextPath.addSegment("deviceComplianceSettingStates").addKeys(new NameValue(id.toString())));
    }

}
