package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.DeviceAppManagement;
import odata.msgraph.client.beta.entity.collection.request.AndroidManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DefaultManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAppManagementTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EnterpriseCodeSigningCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosLobAppProvisioningConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MdmWindowsInformationProtectionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PolicySetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SideLoadingKeyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TargetedManagedAppConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.VppTokenCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionDeviceRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionWipeActionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceAppManagementRequest extends EntityRequest<DeviceAppManagement> {

    public DeviceAppManagementRequest(ContextPath contextPath) {
        super(DeviceAppManagement.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagedEBookCollectionRequest managedEBooks() {
        return new ManagedEBookCollectionRequest(
                        contextPath.addSegment("managedEBooks"));
    }

    public ManagedEBookRequest managedEBooks(String id) {
        return new ManagedEBookRequest(contextPath.addSegment("managedEBooks").addKeys(new NameValue(id.toString())));
    }

    public MobileAppCollectionRequest mobileApps() {
        return new MobileAppCollectionRequest(
                        contextPath.addSegment("mobileApps"));
    }

    public MobileAppRequest mobileApps(String id) {
        return new MobileAppRequest(contextPath.addSegment("mobileApps").addKeys(new NameValue(id.toString())));
    }

    public MobileAppCategoryCollectionRequest mobileAppCategories() {
        return new MobileAppCategoryCollectionRequest(
                        contextPath.addSegment("mobileAppCategories"));
    }

    public MobileAppCategoryRequest mobileAppCategories(String id) {
        return new MobileAppCategoryRequest(contextPath.addSegment("mobileAppCategories").addKeys(new NameValue(id.toString())));
    }

    public EnterpriseCodeSigningCertificateCollectionRequest enterpriseCodeSigningCertificates() {
        return new EnterpriseCodeSigningCertificateCollectionRequest(
                        contextPath.addSegment("enterpriseCodeSigningCertificates"));
    }

    public EnterpriseCodeSigningCertificateRequest enterpriseCodeSigningCertificates(String id) {
        return new EnterpriseCodeSigningCertificateRequest(contextPath.addSegment("enterpriseCodeSigningCertificates").addKeys(new NameValue(id.toString())));
    }

    public IosLobAppProvisioningConfigurationCollectionRequest iosLobAppProvisioningConfigurations() {
        return new IosLobAppProvisioningConfigurationCollectionRequest(
                        contextPath.addSegment("iosLobAppProvisioningConfigurations"));
    }

    public IosLobAppProvisioningConfigurationRequest iosLobAppProvisioningConfigurations(String id) {
        return new IosLobAppProvisioningConfigurationRequest(contextPath.addSegment("iosLobAppProvisioningConfigurations").addKeys(new NameValue(id.toString())));
    }

    public SymantecCodeSigningCertificateRequest symantecCodeSigningCertificate() {
        return new SymantecCodeSigningCertificateRequest(contextPath.addSegment("symantecCodeSigningCertificate"));
    }

    public ManagedDeviceMobileAppConfigurationCollectionRequest mobileAppConfigurations() {
        return new ManagedDeviceMobileAppConfigurationCollectionRequest(
                        contextPath.addSegment("mobileAppConfigurations"));
    }

    public ManagedDeviceMobileAppConfigurationRequest mobileAppConfigurations(String id) {
        return new ManagedDeviceMobileAppConfigurationRequest(contextPath.addSegment("mobileAppConfigurations").addKeys(new NameValue(id.toString())));
    }

    public ManagedEBookCategoryCollectionRequest managedEBookCategories() {
        return new ManagedEBookCategoryCollectionRequest(
                        contextPath.addSegment("managedEBookCategories"));
    }

    public ManagedEBookCategoryRequest managedEBookCategories(String id) {
        return new ManagedEBookCategoryRequest(contextPath.addSegment("managedEBookCategories").addKeys(new NameValue(id.toString())));
    }

    public PolicySetCollectionRequest policySets() {
        return new PolicySetCollectionRequest(
                        contextPath.addSegment("policySets"));
    }

    public PolicySetRequest policySets(String id) {
        return new PolicySetRequest(contextPath.addSegment("policySets").addKeys(new NameValue(id.toString())));
    }

    public SideLoadingKeyCollectionRequest sideLoadingKeys() {
        return new SideLoadingKeyCollectionRequest(
                        contextPath.addSegment("sideLoadingKeys"));
    }

    public SideLoadingKeyRequest sideLoadingKeys(String id) {
        return new SideLoadingKeyRequest(contextPath.addSegment("sideLoadingKeys").addKeys(new NameValue(id.toString())));
    }

    public VppTokenCollectionRequest vppTokens() {
        return new VppTokenCollectionRequest(
                        contextPath.addSegment("vppTokens"));
    }

    public VppTokenRequest vppTokens(String id) {
        return new VppTokenRequest(contextPath.addSegment("vppTokens").addKeys(new NameValue(id.toString())));
    }

    public WindowsManagementAppRequest windowsManagementApp() {
        return new WindowsManagementAppRequest(contextPath.addSegment("windowsManagementApp"));
    }

    public ManagedAppPolicyCollectionRequest managedAppPolicies() {
        return new ManagedAppPolicyCollectionRequest(
                        contextPath.addSegment("managedAppPolicies"));
    }

    public ManagedAppPolicyRequest managedAppPolicies(String id) {
        return new ManagedAppPolicyRequest(contextPath.addSegment("managedAppPolicies").addKeys(new NameValue(id.toString())));
    }

    public IosManagedAppProtectionCollectionRequest iosManagedAppProtections() {
        return new IosManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("iosManagedAppProtections"));
    }

    public IosManagedAppProtectionRequest iosManagedAppProtections(String id) {
        return new IosManagedAppProtectionRequest(contextPath.addSegment("iosManagedAppProtections").addKeys(new NameValue(id.toString())));
    }

    public AndroidManagedAppProtectionCollectionRequest androidManagedAppProtections() {
        return new AndroidManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("androidManagedAppProtections"));
    }

    public AndroidManagedAppProtectionRequest androidManagedAppProtections(String id) {
        return new AndroidManagedAppProtectionRequest(contextPath.addSegment("androidManagedAppProtections").addKeys(new NameValue(id.toString())));
    }

    public DefaultManagedAppProtectionCollectionRequest defaultManagedAppProtections() {
        return new DefaultManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("defaultManagedAppProtections"));
    }

    public DefaultManagedAppProtectionRequest defaultManagedAppProtections(String id) {
        return new DefaultManagedAppProtectionRequest(contextPath.addSegment("defaultManagedAppProtections").addKeys(new NameValue(id.toString())));
    }

    public TargetedManagedAppConfigurationCollectionRequest targetedManagedAppConfigurations() {
        return new TargetedManagedAppConfigurationCollectionRequest(
                        contextPath.addSegment("targetedManagedAppConfigurations"));
    }

    public TargetedManagedAppConfigurationRequest targetedManagedAppConfigurations(String id) {
        return new TargetedManagedAppConfigurationRequest(contextPath.addSegment("targetedManagedAppConfigurations").addKeys(new NameValue(id.toString())));
    }

    public MdmWindowsInformationProtectionPolicyCollectionRequest mdmWindowsInformationProtectionPolicies() {
        return new MdmWindowsInformationProtectionPolicyCollectionRequest(
                        contextPath.addSegment("mdmWindowsInformationProtectionPolicies"));
    }

    public MdmWindowsInformationProtectionPolicyRequest mdmWindowsInformationProtectionPolicies(String id) {
        return new MdmWindowsInformationProtectionPolicyRequest(contextPath.addSegment("mdmWindowsInformationProtectionPolicies").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionPolicyCollectionRequest windowsInformationProtectionPolicies() {
        return new WindowsInformationProtectionPolicyCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionPolicies"));
    }

    public WindowsInformationProtectionPolicyRequest windowsInformationProtectionPolicies(String id) {
        return new WindowsInformationProtectionPolicyRequest(contextPath.addSegment("windowsInformationProtectionPolicies").addKeys(new NameValue(id.toString())));
    }

    public ManagedAppRegistrationCollectionRequest managedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(
                        contextPath.addSegment("managedAppRegistrations"));
    }

    public ManagedAppRegistrationRequest managedAppRegistrations(String id) {
        return new ManagedAppRegistrationRequest(contextPath.addSegment("managedAppRegistrations").addKeys(new NameValue(id.toString())));
    }

    public ManagedAppStatusCollectionRequest managedAppStatuses() {
        return new ManagedAppStatusCollectionRequest(
                        contextPath.addSegment("managedAppStatuses"));
    }

    public ManagedAppStatusRequest managedAppStatuses(String id) {
        return new ManagedAppStatusRequest(contextPath.addSegment("managedAppStatuses").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionDeviceRegistrationCollectionRequest windowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"));
    }

    public WindowsInformationProtectionDeviceRegistrationRequest windowsInformationProtectionDeviceRegistrations(String id) {
        return new WindowsInformationProtectionDeviceRegistrationRequest(contextPath.addSegment("windowsInformationProtectionDeviceRegistrations").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionWipeActionCollectionRequest windowsInformationProtectionWipeActions() {
        return new WindowsInformationProtectionWipeActionCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionWipeActions"));
    }

    public WindowsInformationProtectionWipeActionRequest windowsInformationProtectionWipeActions(String id) {
        return new WindowsInformationProtectionWipeActionRequest(contextPath.addSegment("windowsInformationProtectionWipeActions").addKeys(new NameValue(id.toString())));
    }

    public DeviceAppManagementTaskCollectionRequest deviceAppManagementTasks() {
        return new DeviceAppManagementTaskCollectionRequest(
                        contextPath.addSegment("deviceAppManagementTasks"));
    }

    public DeviceAppManagementTaskRequest deviceAppManagementTasks(String id) {
        return new DeviceAppManagementTaskRequest(contextPath.addSegment("deviceAppManagementTasks").addKeys(new NameValue(id.toString())));
    }

    public WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest wdacSupplementalPolicies() {
        return new WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest(
                        contextPath.addSegment("wdacSupplementalPolicies"));
    }

    public WindowsDefenderApplicationControlSupplementalPolicyRequest wdacSupplementalPolicies(String id) {
        return new WindowsDefenderApplicationControlSupplementalPolicyRequest(contextPath.addSegment("wdacSupplementalPolicies").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "syncMicrosoftStoreForBusinessApps")
    @JsonIgnore
    public ActionRequestNoReturn syncMicrosoftStoreForBusinessApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncMicrosoftStoreForBusinessApps"), _parameters);
    }

}
