package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceAndAppManagementRoleAssignment;
import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceAndAppManagementRoleAssignmentRequest extends EntityRequest<DeviceAndAppManagementRoleAssignment> {

    public DeviceAndAppManagementRoleAssignmentRequest(ContextPath contextPath) {
        super(DeviceAndAppManagementRoleAssignment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public RoleScopeTagCollectionRequest roleScopeTags() {
        return new RoleScopeTagCollectionRequest(
                        contextPath.addSegment("roleScopeTags"));
    }

    public RoleScopeTagRequest roleScopeTags(String id) {
        return new RoleScopeTagRequest(contextPath.addSegment("roleScopeTags").addKeys(new NameValue(id.toString())));
    }

}
