package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.DepOnboardingSetting;
import odata.msgraph.client.beta.entity.collection.request.EnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedAppleDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DepOnboardingSettingRequest extends EntityRequest<DepOnboardingSetting> {

    public DepOnboardingSettingRequest(ContextPath contextPath) {
        super(DepOnboardingSetting.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DepIOSEnrollmentProfileRequest defaultIosEnrollmentProfile() {
        return new DepIOSEnrollmentProfileRequest(contextPath.addSegment("defaultIosEnrollmentProfile"));
    }

    public DepMacOSEnrollmentProfileRequest defaultMacOsEnrollmentProfile() {
        return new DepMacOSEnrollmentProfileRequest(contextPath.addSegment("defaultMacOsEnrollmentProfile"));
    }

    public EnrollmentProfileCollectionRequest enrollmentProfiles() {
        return new EnrollmentProfileCollectionRequest(
                        contextPath.addSegment("enrollmentProfiles"));
    }

    public EnrollmentProfileRequest enrollmentProfiles(String id) {
        return new EnrollmentProfileRequest(contextPath.addSegment("enrollmentProfiles").addKeys(new NameValue(id.toString())));
    }

    public ImportedAppleDeviceIdentityCollectionRequest importedAppleDeviceIdentities() {
        return new ImportedAppleDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedAppleDeviceIdentities"));
    }

    public ImportedAppleDeviceIdentityRequest importedAppleDeviceIdentities(String id) {
        return new ImportedAppleDeviceIdentityRequest(contextPath.addSegment("importedAppleDeviceIdentities").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "generateEncryptionPublicKey")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> generateEncryptionPublicKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateEncryptionPublicKey"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "uploadDepToken")
    @JsonIgnore
    public ActionRequestNoReturn uploadDepToken(String appleId, String depToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("appleId", "Edm.String", Checks.checkIsAscii(appleId))
            .put("depToken", "Edm.String", Checks.checkIsAscii(depToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadDepToken"), _parameters);
    }

    @Action(name = "syncWithAppleDeviceEnrollmentProgram")
    @JsonIgnore
    public ActionRequestNoReturn syncWithAppleDeviceEnrollmentProgram() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncWithAppleDeviceEnrollmentProgram"), _parameters);
    }

    @Action(name = "shareForSchoolDataSyncService")
    @JsonIgnore
    public ActionRequestNoReturn shareForSchoolDataSyncService() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.shareForSchoolDataSyncService"), _parameters);
    }

    @Action(name = "unshareForSchoolDataSyncService")
    @JsonIgnore
    public ActionRequestNoReturn unshareForSchoolDataSyncService() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unshareForSchoolDataSyncService"), _parameters);
    }

    @Function(name = "getEncryptionPublicKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getEncryptionPublicKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEncryptionPublicKey"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
