package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.DataSharingConsent;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DataSharingConsentRequest extends EntityRequest<DataSharingConsent> {

    public DataSharingConsentRequest(ContextPath contextPath) {
        super(DataSharingConsent.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "consentToDataSharing")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DataSharingConsent> consentToDataSharing() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DataSharingConsent>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.consentToDataSharing"), DataSharingConsent.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
