package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.ContentClassification;
import odata.msgraph.client.beta.complex.ExactMatchClassificationResult;
import odata.msgraph.client.beta.entity.DataClassificationService;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchDataStoreCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchUploadAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FileClassificationRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JobResponseBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitiveTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TextClassificationRequestCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DataClassificationServiceRequest extends EntityRequest<DataClassificationService> {

    public DataClassificationServiceRequest(ContextPath contextPath) {
        super(DataClassificationService.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ExactMatchDataStoreCollectionRequest exactMatchDataStores() {
        return new ExactMatchDataStoreCollectionRequest(
                        contextPath.addSegment("exactMatchDataStores"));
    }

    public ExactMatchDataStoreRequest exactMatchDataStores(String id) {
        return new ExactMatchDataStoreRequest(contextPath.addSegment("exactMatchDataStores").addKeys(new NameValue(id.toString())));
    }

    public SensitiveTypeCollectionRequest sensitiveTypes() {
        return new SensitiveTypeCollectionRequest(
                        contextPath.addSegment("sensitiveTypes"));
    }

    public SensitiveTypeRequest sensitiveTypes(String id) {
        return new SensitiveTypeRequest(contextPath.addSegment("sensitiveTypes").addKeys(new NameValue(id.toString())));
    }

    public JobResponseBaseCollectionRequest jobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("jobs"));
    }

    public JobResponseBaseRequest jobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("jobs").addKeys(new NameValue(id.toString())));
    }

    public JobResponseBaseCollectionRequest classifyFileJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyFileJobs"));
    }

    public JobResponseBaseRequest classifyFileJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("classifyFileJobs").addKeys(new NameValue(id.toString())));
    }

    public JobResponseBaseCollectionRequest classifyTextJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyTextJobs"));
    }

    public JobResponseBaseRequest classifyTextJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("classifyTextJobs").addKeys(new NameValue(id.toString())));
    }

    public JobResponseBaseCollectionRequest evaluateLabelJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateLabelJobs"));
    }

    public JobResponseBaseRequest evaluateLabelJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("evaluateLabelJobs").addKeys(new NameValue(id.toString())));
    }

    public JobResponseBaseCollectionRequest evaluateDlpPoliciesJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateDlpPoliciesJobs"));
    }

    public JobResponseBaseRequest evaluateDlpPoliciesJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("evaluateDlpPoliciesJobs").addKeys(new NameValue(id.toString())));
    }

    public JobResponseBaseCollectionRequest labelsAndPoliciesEvaluationJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("labelsAndPoliciesEvaluationJobs"));
    }

    public JobResponseBaseRequest labelsAndPoliciesEvaluationJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("labelsAndPoliciesEvaluationJobs").addKeys(new NameValue(id.toString())));
    }

    public TextClassificationRequestCollectionRequest classifyText() {
        return new TextClassificationRequestCollectionRequest(
                        contextPath.addSegment("classifyText"));
    }

    public TextClassificationRequestRequest classifyText(String id) {
        return new TextClassificationRequestRequest(contextPath.addSegment("classifyText").addKeys(new NameValue(id.toString())));
    }

    public FileClassificationRequestCollectionRequest classifyFile() {
        return new FileClassificationRequestCollectionRequest(
                        contextPath.addSegment("classifyFile"));
    }

    public FileClassificationRequestRequest classifyFile(String id) {
        return new FileClassificationRequestRequest(contextPath.addSegment("classifyFile").addKeys(new NameValue(id.toString())));
    }

    public SensitivityLabelCollectionRequest sensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"));
    }

    public SensitivityLabelRequest sensitivityLabels(String id) {
        return new SensitivityLabelRequest(contextPath.addSegment("sensitivityLabels").addKeys(new NameValue(id.toString())));
    }

    public ExactMatchUploadAgentCollectionRequest exactMatchUploadAgents() {
        return new ExactMatchUploadAgentCollectionRequest(
                        contextPath.addSegment("exactMatchUploadAgents"));
    }

    public ExactMatchUploadAgentRequest exactMatchUploadAgents(String id) {
        return new ExactMatchUploadAgentRequest(contextPath.addSegment("exactMatchUploadAgents").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "classifyExactMatches")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult> classifyExactMatches(String text, String timeoutInMs, List<String> sensitiveTypeIds, List<ContentClassification> contentClassifications) {
        Preconditions.checkNotNull(contentClassifications, "contentClassifications cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("timeoutInMs", "Edm.String", Checks.checkIsAscii(timeoutInMs))
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .put("contentClassifications", "Collection(microsoft.graph.contentClassification)", contentClassifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyExactMatches"), ExactMatchClassificationResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
