package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.CustomerPaymentJournal;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class CustomerPaymentJournalRequest extends EntityRequest<CustomerPaymentJournal> {

    public CustomerPaymentJournalRequest(ContextPath contextPath) {
        super(CustomerPaymentJournal.class, contextPath, SchemaInfo.INSTANCE);
    }

    public CustomerPaymentCollectionRequest customerPayments() {
        return new CustomerPaymentCollectionRequest(
                        contextPath.addSegment("customerPayments"));
    }

    public CustomerPaymentRequest customerPayments(String id) {
        return new CustomerPaymentRequest(contextPath.addSegment("customerPayments").addKeys(new NameValue(id.toString())));
    }

    public AccountRequest account() {
        return new AccountRequest(contextPath.addSegment("account"));
    }

}
