package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Conversation;
import odata.msgraph.client.beta.entity.collection.request.ConversationThreadCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ConversationRequest extends EntityRequest<Conversation> {

    public ConversationRequest(ContextPath contextPath) {
        super(Conversation.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ConversationThreadCollectionRequest threads() {
        return new ConversationThreadCollectionRequest(
                        contextPath.addSegment("threads"));
    }

    public ConversationThreadRequest threads(String id) {
        return new ConversationThreadRequest(contextPath.addSegment("threads").addKeys(new NameValue(id.toString())));
    }

}
