package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ContentType;
import odata.msgraph.client.beta.entity.collection.request.ColumnLinkCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ContentTypeRequest extends EntityRequest<ContentType> {

    public ContentTypeRequest(ContextPath contextPath) {
        super(ContentType.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ColumnLinkCollectionRequest columnLinks() {
        return new ColumnLinkCollectionRequest(
                        contextPath.addSegment("columnLinks"));
    }

    public ColumnLinkRequest columnLinks(String id) {
        return new ColumnLinkRequest(contextPath.addSegment("columnLinks").addKeys(new NameValue(id.toString())));
    }

}
