package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ContactFolder;
import odata.msgraph.client.beta.entity.collection.request.ContactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ContactFolderRequest extends EntityRequest<ContactFolder> {

    public ContactFolderRequest(ContextPath contextPath) {
        super(ContactFolder.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public ContactCollectionRequest contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contacts"));
    }

    public ContactRequest contacts(String id) {
        return new ContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(id.toString())));
    }

    public ContactFolderCollectionRequest childFolders() {
        return new ContactFolderCollectionRequest(
                        contextPath.addSegment("childFolders"));
    }

    public ContactFolderRequest childFolders(String id) {
        return new ContactFolderRequest(contextPath.addSegment("childFolders").addKeys(new NameValue(id.toString())));
    }

}
