package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Connector;
import odata.msgraph.client.beta.entity.collection.request.ConnectorGroupCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ConnectorRequest extends EntityRequest<Connector> {

    public ConnectorRequest(ContextPath contextPath) {
        super(Connector.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ConnectorGroupCollectionRequest memberOf() {
        return new ConnectorGroupCollectionRequest(
                        contextPath.addSegment("memberOf"));
    }

    public ConnectorGroupRequest memberOf(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

}
