package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ConnectorGroup;
import odata.msgraph.client.beta.entity.collection.request.ApplicationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectorCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ConnectorGroupRequest extends EntityRequest<ConnectorGroup> {

    public ConnectorGroupRequest(ContextPath contextPath) {
        super(ConnectorGroup.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ConnectorCollectionRequest members() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("members"));
    }

    public ConnectorRequest members(String id) {
        return new ConnectorRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ApplicationCollectionRequest applications() {
        return new ApplicationCollectionRequest(
                        contextPath.addSegment("applications"));
    }

    public ApplicationRequest applications(String id) {
        return new ApplicationRequest(contextPath.addSegment("applications").addKeys(new NameValue(id.toString())));
    }

}
