package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ConnectedOrganization;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ConnectedOrganizationRequest extends EntityRequest<ConnectedOrganization> {

    public ConnectedOrganizationRequest(ContextPath contextPath) {
        super(ConnectedOrganization.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DirectoryObjectCollectionRequest internalSponsors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("internalSponsors"));
    }

    public DirectoryObjectRequest internalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("internalSponsors").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest externalSponsors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("externalSponsors"));
    }

    public DirectoryObjectRequest externalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("externalSponsors").addKeys(new NameValue(id.toString())));
    }

}
