package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ConditionalAccessRoot;
import odata.msgraph.client.beta.entity.collection.request.ConditionalAccessPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NamedLocationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ConditionalAccessRootRequest extends EntityRequest<ConditionalAccessRoot> {

    public ConditionalAccessRootRequest(ContextPath contextPath) {
        super(ConditionalAccessRoot.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ConditionalAccessPolicyCollectionRequest policies() {
        return new ConditionalAccessPolicyCollectionRequest(
                        contextPath.addSegment("policies"));
    }

    public ConditionalAccessPolicyRequest policies(String id) {
        return new ConditionalAccessPolicyRequest(contextPath.addSegment("policies").addKeys(new NameValue(id.toString())));
    }

    public NamedLocationCollectionRequest namedLocations() {
        return new NamedLocationCollectionRequest(
                        contextPath.addSegment("namedLocations"));
    }

    public NamedLocationRequest namedLocations(String id) {
        return new NamedLocationRequest(contextPath.addSegment("namedLocations").addKeys(new NameValue(id.toString())));
    }

}
