package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.CommsApplication;
import odata.msgraph.client.beta.entity.collection.request.CallCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class CommsApplicationRequest extends EntityRequest<CommsApplication> {

    public CommsApplicationRequest(ContextPath contextPath) {
        super(CommsApplication.class, contextPath, SchemaInfo.INSTANCE);
    }

    public CallCollectionRequest calls() {
        return new CallCollectionRequest(
                        contextPath.addSegment("calls"));
    }

    public CallRequest calls(String id) {
        return new CallRequest(contextPath.addSegment("calls").addKeys(new NameValue(id.toString())));
    }

    public OnlineMeetingCollectionRequest onlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"));
    }

    public OnlineMeetingRequest onlineMeetings(String id) {
        return new OnlineMeetingRequest(contextPath.addSegment("onlineMeetings").addKeys(new NameValue(id.toString())));
    }

}
