package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.callRecords.entity.collection.request.CallRecordCollectionRequest;
import odata.msgraph.client.beta.callRecords.entity.request.CallRecordRequest;
import odata.msgraph.client.beta.entity.CloudCommunications;
import odata.msgraph.client.beta.entity.Presence;
import odata.msgraph.client.beta.entity.collection.request.CallCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PresenceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class CloudCommunicationsRequest extends EntityRequest<CloudCommunications> {

    public CloudCommunicationsRequest(ContextPath contextPath) {
        super(CloudCommunications.class, contextPath, SchemaInfo.INSTANCE);
    }

    public CallCollectionRequest calls() {
        return new CallCollectionRequest(
                        contextPath.addSegment("calls"));
    }

    public CallRequest calls(String id) {
        return new CallRequest(contextPath.addSegment("calls").addKeys(new NameValue(id.toString())));
    }

    public CallRecordCollectionRequest callRecords() {
        return new CallRecordCollectionRequest(
                        contextPath.addSegment("callRecords"));
    }

    public CallRecordRequest callRecords(String id) {
        return new CallRecordRequest(contextPath.addSegment("callRecords").addKeys(new NameValue(id.toString())));
    }

    public OnlineMeetingCollectionRequest onlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"));
    }

    public OnlineMeetingRequest onlineMeetings(String id) {
        return new OnlineMeetingRequest(contextPath.addSegment("onlineMeetings").addKeys(new NameValue(id.toString())));
    }

    public PresenceCollectionRequest presences() {
        return new PresenceCollectionRequest(
                        contextPath.addSegment("presences"));
    }

    public PresenceRequest presences(String id) {
        return new PresenceRequest(contextPath.addSegment("presences").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "getPresencesByUserId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Presence> getPresencesByUserId(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPresencesByUserId"), Presence.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
