package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageHostedContentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ChatMessageRequest extends EntityRequest<ChatMessage> {

    public ChatMessageRequest(ContextPath contextPath) {
        super(ChatMessage.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ChatMessageCollectionRequest replies() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("replies"));
    }

    public ChatMessageRequest replies(String id) {
        return new ChatMessageRequest(contextPath.addSegment("replies").addKeys(new NameValue(id.toString())));
    }

    public ChatMessageHostedContentCollectionRequest hostedContents() {
        return new ChatMessageHostedContentCollectionRequest(
                        contextPath.addSegment("hostedContents"));
    }

    public ChatMessageHostedContentRequest hostedContents(String id) {
        return new ChatMessageHostedContentRequest(contextPath.addSegment("hostedContents").addKeys(new NameValue(id.toString())));
    }

}
