package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Channel;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsTabCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ChannelRequest extends EntityRequest<Channel> {

    public ChannelRequest(ContextPath contextPath) {
        super(Channel.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ChatMessageCollectionRequest messages() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("messages"));
    }

    public ChatMessageRequest messages(String id) {
        return new ChatMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id.toString())));
    }

    public TeamsTabCollectionRequest tabs() {
        return new TeamsTabCollectionRequest(
                        contextPath.addSegment("tabs"));
    }

    public TeamsTabRequest tabs(String id) {
        return new TeamsTabRequest(contextPath.addSegment("tabs").addKeys(new NameValue(id.toString())));
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"));
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public DriveItemRequest filesFolder() {
        return new DriveItemRequest(contextPath.addSegment("filesFolder"));
    }

}
