package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.CalendarGroup;
import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class CalendarGroupRequest extends EntityRequest<CalendarGroup> {

    public CalendarGroupRequest(ContextPath contextPath) {
        super(CalendarGroup.class, contextPath, SchemaInfo.INSTANCE);
    }

    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"));
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id.toString())));
    }

}
