package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.BusinessFlow;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class BusinessFlowRequest extends EntityRequest<BusinessFlow> {

    public BusinessFlowRequest(ContextPath contextPath) {
        super(BusinessFlow.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "recordDecisions")
    @JsonIgnore
    public ActionRequestNoReturn recordDecisions(String reviewResult, String justification) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reviewResult", "Edm.String", Checks.checkIsAscii(reviewResult))
            .put("justification", "Edm.String", Checks.checkIsAscii(justification))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recordDecisions"), _parameters);
    }

}
