package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.BookingBusiness;
import odata.msgraph.client.beta.entity.collection.request.BookingAppointmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BookingCustomerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BookingServiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BookingStaffMemberCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class BookingBusinessRequest extends EntityRequest<BookingBusiness> {

    public BookingBusinessRequest(ContextPath contextPath) {
        super(BookingBusiness.class, contextPath, SchemaInfo.INSTANCE);
    }

    public BookingAppointmentCollectionRequest appointments() {
        return new BookingAppointmentCollectionRequest(
                        contextPath.addSegment("appointments"));
    }

    public BookingAppointmentRequest appointments(String id) {
        return new BookingAppointmentRequest(contextPath.addSegment("appointments").addKeys(new NameValue(id.toString())));
    }

    public BookingAppointmentCollectionRequest calendarView() {
        return new BookingAppointmentCollectionRequest(
                        contextPath.addSegment("calendarView"));
    }

    public BookingAppointmentRequest calendarView(String id) {
        return new BookingAppointmentRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id.toString())));
    }

    public BookingCustomerCollectionRequest customers() {
        return new BookingCustomerCollectionRequest(
                        contextPath.addSegment("customers"));
    }

    public BookingCustomerRequest customers(String id) {
        return new BookingCustomerRequest(contextPath.addSegment("customers").addKeys(new NameValue(id.toString())));
    }

    public BookingServiceCollectionRequest services() {
        return new BookingServiceCollectionRequest(
                        contextPath.addSegment("services"));
    }

    public BookingServiceRequest services(String id) {
        return new BookingServiceRequest(contextPath.addSegment("services").addKeys(new NameValue(id.toString())));
    }

    public BookingStaffMemberCollectionRequest staffMembers() {
        return new BookingStaffMemberCollectionRequest(
                        contextPath.addSegment("staffMembers"));
    }

    public BookingStaffMemberRequest staffMembers(String id) {
        return new BookingStaffMemberRequest(contextPath.addSegment("staffMembers").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestNoReturn publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), _parameters);
    }

    @Action(name = "unpublish")
    @JsonIgnore
    public ActionRequestNoReturn unpublish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unpublish"), _parameters);
    }

}
