package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.BookingAppointment;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class BookingAppointmentRequest extends EntityRequest<BookingAppointment> {

    public BookingAppointmentRequest(ContextPath contextPath) {
        super(BookingAppointment.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel(String cancellationMessage) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cancellationMessage", "Edm.String", Checks.checkIsAscii(cancellationMessage))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

}
