package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Bitlocker;
import odata.msgraph.client.beta.entity.collection.request.BitlockerRecoveryKeyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class BitlockerRequest extends EntityRequest<Bitlocker> {

    public BitlockerRequest(ContextPath contextPath) {
        super(Bitlocker.class, contextPath, SchemaInfo.INSTANCE);
    }

    public BitlockerRecoveryKeyCollectionRequest recoveryKeys() {
        return new BitlockerRecoveryKeyCollectionRequest(
                        contextPath.addSegment("recoveryKeys"));
    }

    public BitlockerRecoveryKeyRequest recoveryKeys(String id) {
        return new BitlockerRecoveryKeyRequest(contextPath.addSegment("recoveryKeys").addKeys(new NameValue(id.toString())));
    }

}
