package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.BaseItem;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class BaseItemRequest extends EntityRequest<BaseItem> {

    public BaseItemRequest(ContextPath contextPath) {
        super(BaseItem.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UserRequest createdByUser() {
        return new UserRequest(contextPath.addSegment("createdByUser"));
    }

    public UserRequest lastModifiedByUser() {
        return new UserRequest(contextPath.addSegment("lastModifiedByUser"));
    }

}
