package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Authentication;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmailAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.Fido2AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PhoneAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityQuestionAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SoftwareOathAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TemporaryAccessPassAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AuthenticationRequest extends EntityRequest<Authentication> {

    public AuthenticationRequest(ContextPath contextPath) {
        super(Authentication.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AuthenticationMethodCollectionRequest methods() {
        return new AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("methods"));
    }

    public AuthenticationMethodRequest methods(String id) {
        return new AuthenticationMethodRequest(contextPath.addSegment("methods").addKeys(new NameValue(id.toString())));
    }

    public SecurityQuestionAuthenticationMethodCollectionRequest securityQuestionMethods() {
        return new SecurityQuestionAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("securityQuestionMethods"));
    }

    public SecurityQuestionAuthenticationMethodRequest securityQuestionMethods(String id) {
        return new SecurityQuestionAuthenticationMethodRequest(contextPath.addSegment("securityQuestionMethods").addKeys(new NameValue(id.toString())));
    }

    public PhoneAuthenticationMethodCollectionRequest phoneMethods() {
        return new PhoneAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("phoneMethods"));
    }

    public PhoneAuthenticationMethodRequest phoneMethods(String id) {
        return new PhoneAuthenticationMethodRequest(contextPath.addSegment("phoneMethods").addKeys(new NameValue(id.toString())));
    }

    public PasswordAuthenticationMethodCollectionRequest passwordMethods() {
        return new PasswordAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordMethods"));
    }

    public PasswordAuthenticationMethodRequest passwordMethods(String id) {
        return new PasswordAuthenticationMethodRequest(contextPath.addSegment("passwordMethods").addKeys(new NameValue(id.toString())));
    }

    public LongRunningOperationCollectionRequest operations() {
        return new LongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    public LongRunningOperationRequest operations(String id) {
        return new LongRunningOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

    public EmailAuthenticationMethodCollectionRequest emailMethods() {
        return new EmailAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("emailMethods"));
    }

    public EmailAuthenticationMethodRequest emailMethods(String id) {
        return new EmailAuthenticationMethodRequest(contextPath.addSegment("emailMethods").addKeys(new NameValue(id.toString())));
    }

    public SoftwareOathAuthenticationMethodCollectionRequest oathMethods() {
        return new SoftwareOathAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("oathMethods"));
    }

    public SoftwareOathAuthenticationMethodRequest oathMethods(String id) {
        return new SoftwareOathAuthenticationMethodRequest(contextPath.addSegment("oathMethods").addKeys(new NameValue(id.toString())));
    }

    public MicrosoftAuthenticatorAuthenticationMethodCollectionRequest microsoftAuthenticatorMethods() {
        return new MicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("microsoftAuthenticatorMethods"));
    }

    public MicrosoftAuthenticatorAuthenticationMethodRequest microsoftAuthenticatorMethods(String id) {
        return new MicrosoftAuthenticatorAuthenticationMethodRequest(contextPath.addSegment("microsoftAuthenticatorMethods").addKeys(new NameValue(id.toString())));
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest passwordlessMicrosoftAuthenticatorMethods() {
        return new PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordlessMicrosoftAuthenticatorMethods"));
    }

    public PasswordlessMicrosoftAuthenticatorAuthenticationMethodRequest passwordlessMicrosoftAuthenticatorMethods(String id) {
        return new PasswordlessMicrosoftAuthenticatorAuthenticationMethodRequest(contextPath.addSegment("passwordlessMicrosoftAuthenticatorMethods").addKeys(new NameValue(id.toString())));
    }

    public Fido2AuthenticationMethodCollectionRequest fido2Methods() {
        return new Fido2AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("fido2Methods"));
    }

    public Fido2AuthenticationMethodRequest fido2Methods(String id) {
        return new Fido2AuthenticationMethodRequest(contextPath.addSegment("fido2Methods").addKeys(new NameValue(id.toString())));
    }

    public TemporaryAccessPassAuthenticationMethodCollectionRequest temporaryAccessPassMethods() {
        return new TemporaryAccessPassAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("temporaryAccessPassMethods"));
    }

    public TemporaryAccessPassAuthenticationMethodRequest temporaryAccessPassMethods(String id) {
        return new TemporaryAccessPassAuthenticationMethodRequest(contextPath.addSegment("temporaryAccessPassMethods").addKeys(new NameValue(id.toString())));
    }

}
