package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AuditLogRoot;
import odata.msgraph.client.beta.entity.collection.request.DirectoryAuditCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProvisioningObjectSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RestrictedSignInCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SignInCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AuditLogRootRequest extends EntityRequest<AuditLogRoot> {

    public AuditLogRootRequest(ContextPath contextPath) {
        super(AuditLogRoot.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SignInCollectionRequest signIns() {
        return new SignInCollectionRequest(
                        contextPath.addSegment("signIns"));
    }

    public SignInRequest signIns(String id) {
        return new SignInRequest(contextPath.addSegment("signIns").addKeys(new NameValue(id.toString())));
    }

    public DirectoryAuditCollectionRequest directoryAudits() {
        return new DirectoryAuditCollectionRequest(
                        contextPath.addSegment("directoryAudits"));
    }

    public DirectoryAuditRequest directoryAudits(String id) {
        return new DirectoryAuditRequest(contextPath.addSegment("directoryAudits").addKeys(new NameValue(id.toString())));
    }

    public RestrictedSignInCollectionRequest restrictedSignIns() {
        return new RestrictedSignInCollectionRequest(
                        contextPath.addSegment("restrictedSignIns"));
    }

    public RestrictedSignInRequest restrictedSignIns(String id) {
        return new RestrictedSignInRequest(contextPath.addSegment("restrictedSignIns").addKeys(new NameValue(id.toString())));
    }

    public ProvisioningObjectSummaryCollectionRequest directoryProvisioning() {
        return new ProvisioningObjectSummaryCollectionRequest(
                        contextPath.addSegment("directoryProvisioning"));
    }

    public ProvisioningObjectSummaryRequest directoryProvisioning(String id) {
        return new ProvisioningObjectSummaryRequest(contextPath.addSegment("directoryProvisioning").addKeys(new NameValue(id.toString())));
    }

    public ProvisioningObjectSummaryCollectionRequest provisioning() {
        return new ProvisioningObjectSummaryCollectionRequest(
                        contextPath.addSegment("provisioning"));
    }

    public ProvisioningObjectSummaryRequest provisioning(String id) {
        return new ProvisioningObjectSummaryRequest(contextPath.addSegment("provisioning").addKeys(new NameValue(id.toString())));
    }

}
