package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ApprovalWorkflowProvider;
import odata.msgraph.client.beta.entity.collection.request.BusinessFlowCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernancePolicyTemplateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ApprovalWorkflowProviderRequest extends EntityRequest<ApprovalWorkflowProvider> {

    public ApprovalWorkflowProviderRequest(ContextPath contextPath) {
        super(ApprovalWorkflowProvider.class, contextPath, SchemaInfo.INSTANCE);
    }

    public BusinessFlowCollectionRequest businessFlows() {
        return new BusinessFlowCollectionRequest(
                        contextPath.addSegment("businessFlows"));
    }

    public BusinessFlowRequest businessFlows(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlows").addKeys(new NameValue(id.toString())));
    }

    public GovernancePolicyTemplateCollectionRequest policyTemplates() {
        return new GovernancePolicyTemplateCollectionRequest(
                        contextPath.addSegment("policyTemplates"));
    }

    public GovernancePolicyTemplateRequest policyTemplates(String id) {
        return new GovernancePolicyTemplateRequest(contextPath.addSegment("policyTemplates").addKeys(new NameValue(id.toString())));
    }

    public BusinessFlowCollectionRequest businessFlowsWithRequestsAwaitingMyDecision() {
        return new BusinessFlowCollectionRequest(
                        contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision"));
    }

    public BusinessFlowRequest businessFlowsWithRequestsAwaitingMyDecision(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision").addKeys(new NameValue(id.toString())));
    }

}
