package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Approval;
import odata.msgraph.client.beta.entity.collection.request.ApprovalStepCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ApprovalRequest extends EntityRequest<Approval> {

    public ApprovalRequest(ContextPath contextPath) {
        super(Approval.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ApprovalStepCollectionRequest pendingSteps() {
        return new ApprovalStepCollectionRequest(
                        contextPath.addSegment("pendingSteps"));
    }

    public ApprovalStepRequest pendingSteps(String id) {
        return new ApprovalStepRequest(contextPath.addSegment("pendingSteps").addKeys(new NameValue(id.toString())));
    }

    public ApprovalStepCollectionRequest completedSteps() {
        return new ApprovalStepCollectionRequest(
                        contextPath.addSegment("completedSteps"));
    }

    public ApprovalStepRequest completedSteps(String id) {
        return new ApprovalStepRequest(contextPath.addSegment("completedSteps").addKeys(new NameValue(id.toString())));
    }

    public RequestRequest request() {
        return new RequestRequest(contextPath.addSegment("request"));
    }

}
