package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.KeyCredential;
import odata.msgraph.client.beta.complex.PasswordCredential;
import odata.msgraph.client.beta.entity.Application;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ApplicationRequest extends EntityRequest<Application> {

    public ApplicationRequest(ContextPath contextPath) {
        super(Application.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ExtensionPropertyCollectionRequest extensionProperties() {
        return new ExtensionPropertyCollectionRequest(
                        contextPath.addSegment("extensionProperties"));
    }

    public ExtensionPropertyRequest extensionProperties(String id) {
        return new ExtensionPropertyRequest(contextPath.addSegment("extensionProperties").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectRequest createdOnBehalfOf() {
        return new DirectoryObjectRequest(contextPath.addSegment("createdOnBehalfOf"));
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"));
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id.toString())));
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"));
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"));
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id.toString())));
    }

    public ConnectorGroupRequest connectorGroup() {
        return new ConnectorGroupRequest(contextPath.addSegment("connectorGroup"));
    }

    public SynchronizationRequest synchronization() {
        return new SynchronizationRequest(contextPath.addSegment("synchronization"));
    }

    @Action(name = "addKey")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<KeyCredential> addKey(KeyCredential keyCredential, PasswordCredential passwordCredential, String proof) {
        Preconditions.checkNotNull(keyCredential, "keyCredential cannot be null");
        Preconditions.checkNotNull(proof, "proof cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyCredential", "microsoft.graph.keyCredential", keyCredential)
            .put("passwordCredential", "microsoft.graph.passwordCredential", passwordCredential)
            .put("proof", "Edm.String", Checks.checkIsAscii(proof))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<KeyCredential>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addKey"), KeyCredential.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "addPassword")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordCredential> addPassword(PasswordCredential passwordCredential) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("passwordCredential", "microsoft.graph.passwordCredential", passwordCredential)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordCredential>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addPassword"), PasswordCredential.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "removeKey")
    @JsonIgnore
    public ActionRequestNoReturn removeKey(String keyId, String proof) {
        Preconditions.checkNotNull(keyId, "keyId cannot be null");
        Preconditions.checkNotNull(proof, "proof cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyId", "Edm.Guid", keyId)
            .put("proof", "Edm.String", Checks.checkIsAscii(proof))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeKey"), _parameters);
    }

    @Action(name = "removePassword")
    @JsonIgnore
    public ActionRequestNoReturn removePassword(String keyId) {
        Preconditions.checkNotNull(keyId, "keyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyId", "Edm.Guid", keyId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removePassword"), _parameters);
    }

}
