package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AppleUserInitiatedEnrollmentProfile;
import odata.msgraph.client.beta.entity.collection.request.AppleEnrollmentProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AppleUserInitiatedEnrollmentProfileRequest extends EntityRequest<AppleUserInitiatedEnrollmentProfile> {

    public AppleUserInitiatedEnrollmentProfileRequest(ContextPath contextPath) {
        super(AppleUserInitiatedEnrollmentProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AppleEnrollmentProfileAssignmentCollectionRequest assignments() {
        return new AppleEnrollmentProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public AppleEnrollmentProfileAssignmentRequest assignments(String id) {
        return new AppleEnrollmentProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "setPriority")
    @JsonIgnore
    public ActionRequestNoReturn setPriority(Integer priority) {
        Preconditions.checkNotNull(priority, "priority cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("priority", "Edm.Int32", priority)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setPriority"), _parameters);
    }

}
