package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AppVulnerabilityTask;
import odata.msgraph.client.beta.entity.collection.request.AppVulnerabilityManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppVulnerabilityMobileAppCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AppVulnerabilityTaskRequest extends EntityRequest<AppVulnerabilityTask> {

    public AppVulnerabilityTaskRequest(ContextPath contextPath) {
        super(AppVulnerabilityTask.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AppVulnerabilityManagedDeviceCollectionRequest managedDevices() {
        return new AppVulnerabilityManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"));
    }

    public AppVulnerabilityManagedDeviceRequest managedDevices(String id) {
        return new AppVulnerabilityManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id.toString())));
    }

    public AppVulnerabilityMobileAppCollectionRequest mobileApps() {
        return new AppVulnerabilityMobileAppCollectionRequest(
                        contextPath.addSegment("mobileApps"));
    }

    public AppVulnerabilityMobileAppRequest mobileApps(String id) {
        return new AppVulnerabilityMobileAppRequest(contextPath.addSegment("mobileApps").addKeys(new NameValue(id.toString())));
    }

}
