package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.AppLogCollectionDownloadDetails;
import odata.msgraph.client.beta.entity.AppLogCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AppLogCollectionRequestRequest extends EntityRequest<AppLogCollectionRequest> {

    public AppLogCollectionRequestRequest(ContextPath contextPath) {
        super(AppLogCollectionRequest.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "createDownloadUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AppLogCollectionDownloadDetails> createDownloadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<AppLogCollectionDownloadDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDownloadUrl"), AppLogCollectionDownloadDetails.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
