package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AppConsentRequest;
import odata.msgraph.client.beta.entity.collection.request.UserConsentRequestCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AppConsentRequestRequest extends EntityRequest<AppConsentRequest> {

    public AppConsentRequestRequest(ContextPath contextPath) {
        super(AppConsentRequest.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UserConsentRequestCollectionRequest userConsentRequests() {
        return new UserConsentRequestCollectionRequest(
                        contextPath.addSegment("userConsentRequests"));
    }

    public UserConsentRequestRequest userConsentRequests(String id) {
        return new UserConsentRequestRequest(contextPath.addSegment("userConsentRequests").addKeys(new NameValue(id.toString())));
    }

}
