package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AppCatalogs;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AppCatalogsRequest extends EntityRequest<AppCatalogs> {

    public AppCatalogsRequest(ContextPath contextPath) {
        super(AppCatalogs.class, contextPath, SchemaInfo.INSTANCE);
    }

    public TeamsAppCollectionRequest teamsApps() {
        return new TeamsAppCollectionRequest(
                        contextPath.addSegment("teamsApps"));
    }

    public TeamsAppRequest teamsApps(String id) {
        return new TeamsAppRequest(contextPath.addSegment("teamsApps").addKeys(new NameValue(id.toString())));
    }

}
