package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AndroidForWorkSettings;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AndroidForWorkSettingsRequest extends EntityRequest<AndroidForWorkSettings> {

    public AndroidForWorkSettingsRequest(ContextPath contextPath) {
        super(AndroidForWorkSettings.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "requestSignupUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> requestSignupUrl(String hostName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("hostName", "Edm.String", Checks.checkIsAscii(hostName))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestSignupUrl"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "completeSignup")
    @JsonIgnore
    public ActionRequestNoReturn completeSignup(String enterpriseToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enterpriseToken", "Edm.String", Checks.checkIsAscii(enterpriseToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeSignup"), _parameters);
    }

    @Action(name = "syncApps")
    @JsonIgnore
    public ActionRequestNoReturn syncApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncApps"), _parameters);
    }

    @Action(name = "unbind")
    @JsonIgnore
    public ActionRequestNoReturn unbind() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unbind"), _parameters);
    }

}
