package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.AndroidEnterpriseWiFiConfiguration;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AndroidEnterpriseWiFiConfigurationRequest extends EntityRequest<AndroidEnterpriseWiFiConfiguration> {

    public AndroidEnterpriseWiFiConfigurationRequest(ContextPath contextPath) {
        super(AndroidEnterpriseWiFiConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AndroidTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new AndroidTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"));
    }

    public AndroidCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new AndroidCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

}
