package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AndroidDeviceOwnerImportedPFXCertificateProfile;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AndroidDeviceOwnerImportedPFXCertificateProfileRequest extends EntityRequest<AndroidDeviceOwnerImportedPFXCertificateProfile> {

    public AndroidDeviceOwnerImportedPFXCertificateProfileRequest(ContextPath contextPath) {
        super(AndroidDeviceOwnerImportedPFXCertificateProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagedDeviceCertificateStateCollectionRequest managedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"));
    }

    public ManagedDeviceCertificateStateRequest managedDeviceCertificateStates(String id) {
        return new ManagedDeviceCertificateStateRequest(contextPath.addSegment("managedDeviceCertificateStates").addKeys(new NameValue(id.toString())));
    }

}
