package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.AndroidDeviceOwnerEnterpriseWiFiConfiguration;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest extends EntityRequest<AndroidDeviceOwnerEnterpriseWiFiConfiguration> {

    public AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest(ContextPath contextPath) {
        super(AndroidDeviceOwnerEnterpriseWiFiConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AndroidDeviceOwnerTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new AndroidDeviceOwnerTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"));
    }

    public AndroidDeviceOwnerCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new AndroidDeviceOwnerCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"));
    }

}
