package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AndroidDeviceOwnerEnrollmentProfile;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AndroidDeviceOwnerEnrollmentProfileRequest extends EntityRequest<AndroidDeviceOwnerEnrollmentProfile> {

    public AndroidDeviceOwnerEnrollmentProfileRequest(ContextPath contextPath) {
        super(AndroidDeviceOwnerEnrollmentProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "revokeToken")
    @JsonIgnore
    public ActionRequestNoReturn revokeToken() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeToken"), _parameters);
    }

    @Action(name = "createToken")
    @JsonIgnore
    public ActionRequestNoReturn createToken(Integer tokenValidityInSeconds) {
        Preconditions.checkNotNull(tokenValidityInSeconds, "tokenValidityInSeconds cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tokenValidityInSeconds", "Edm.Int32", tokenValidityInSeconds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createToken"), _parameters);
    }

}
