package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Agreement;
import odata.msgraph.client.beta.entity.collection.request.AgreementFileCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AgreementRequest extends EntityRequest<Agreement> {

    public AgreementRequest(ContextPath contextPath) {
        super(Agreement.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AgreementFileCollectionRequest files() {
        return new AgreementFileCollectionRequest(
                        contextPath.addSegment("files"));
    }

    public AgreementFileRequest files(String id) {
        return new AgreementFileRequest(contextPath.addSegment("files").addKeys(new NameValue(id.toString())));
    }

}
