package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AdvancedThreatProtectionOnboardingStateSummary;
import odata.msgraph.client.beta.entity.collection.request.AdvancedThreatProtectionOnboardingDeviceSettingStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AdvancedThreatProtectionOnboardingStateSummaryRequest extends EntityRequest<AdvancedThreatProtectionOnboardingStateSummary> {

    public AdvancedThreatProtectionOnboardingStateSummaryRequest(ContextPath contextPath) {
        super(AdvancedThreatProtectionOnboardingStateSummary.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AdvancedThreatProtectionOnboardingDeviceSettingStateCollectionRequest advancedThreatProtectionOnboardingDeviceSettingStates() {
        return new AdvancedThreatProtectionOnboardingDeviceSettingStateCollectionRequest(
                        contextPath.addSegment("advancedThreatProtectionOnboardingDeviceSettingStates"));
    }

    public AdvancedThreatProtectionOnboardingDeviceSettingStateRequest advancedThreatProtectionOnboardingDeviceSettingStates(String id) {
        return new AdvancedThreatProtectionOnboardingDeviceSettingStateRequest(contextPath.addSegment("advancedThreatProtectionOnboardingDeviceSettingStates").addKeys(new NameValue(id.toString())));
    }

}
