package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AdministrativeUnit;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AdministrativeUnitRequest extends EntityRequest<AdministrativeUnit> {

    public AdministrativeUnitRequest(ContextPath contextPath) {
        super(AdministrativeUnit.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("members"));
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMembers() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedRoleMembers"));
    }

    public ScopedRoleMembershipRequest scopedRoleMembers(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMembers").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

}
