package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessReviewSet;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewScheduleDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessReviewSetRequest extends EntityRequest<AccessReviewSet> {

    public AccessReviewSetRequest(ContextPath contextPath) {
        super(AccessReviewSet.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessReviewScheduleDefinitionCollectionRequest definitions() {
        return new AccessReviewScheduleDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"));
    }

    public AccessReviewScheduleDefinitionRequest definitions(String id) {
        return new AccessReviewScheduleDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id.toString())));
    }

}
