package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AccessReviewScheduleDefinition;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessReviewScheduleDefinitionRequest extends EntityRequest<AccessReviewScheduleDefinition> {

    public AccessReviewScheduleDefinitionRequest(ContextPath contextPath) {
        super(AccessReviewScheduleDefinition.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessReviewInstanceCollectionRequest instances() {
        return new AccessReviewInstanceCollectionRequest(
                        contextPath.addSegment("instances"));
    }

    public AccessReviewInstanceRequest instances(String id) {
        return new AccessReviewInstanceRequest(contextPath.addSegment("instances").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

}
